<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            //
            $table->string('referal_code')->nullable();
            $table->boolean('status')->default(true);
            $table->string('token', 150)->nullable();
            $table->boolean('verified')->default(false);
            $table->string('forgot_password_token', 150)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            //
            $table->dropColumn('referal_code');
            $table->dropColumn('status');
            $table->dropColumn('token');
            $table->dropColumn('verified');
            $table->dropColumn('forgot_password_token');
        });
    }
}
