<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SellerRotator extends Model
{
  //use SoftDeletes;

  public $table = 'seller_rotator';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'user_id',
    'status',
    'weight',
    'weight_current',
    'counter',
    'current'
  ];

  protected $casts = [
    'id'  => 'integer',
    'user_id' => 'integer',
    'status' => 'boolean',
    'weight' => 'integer',
    'weight_current' => 'integer',
    'counter' => 'integer',
    'current' => 'boolean'
  ];

  public static $rules = [
    'user_id'  => 'required|integer'
  ];

  public function user() {
    return $this->belongsTo(\App\User::class, 'user_id');
  }
}