<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
  use SoftDeletes;

  public $table = 'products';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'name',
    'code',
    'description',
    'url',
    'status'
  ];

  protected $casts = [
    'id'  => 'integer',
    'name'  => 'string',
    'code'  => 'string',
    'description' => 'string',
    'url' => 'string',
    'status'  => 'boolean'
  ];

  public static $rules = [
    'name'  => 'required',
    'code'  => 'required|unique:products',
    'url' => 'required'
  ];

  public function trackings() {
    return $this->hasMany(\App\Tracking::class);
  }
  
}