<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ParcelReturn extends Model
{
  //use SoftDeletes;

  public $table = 'parcel_return_records';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'user_id',
    'sender',
    'customer_name',
    'customer_phone',
    'tracking_no',
    'status',
    'products',
    'remarks',
    'post_date',
    'return_date'
  ];

  protected $casts = [
    'id'  => 'integer',
    'sender'  => 'integer',
    'user_id' => 'integer',
    'post_date'  => 'date|Y-m-d',
    'return_date' => 'date|Y-m-d',
    'customer_name' => 'string',
    'customer_phone'  => 'string',
    'tracking_no' => 'string',
    'products'  => 'array',
    'remarks' => 'string',
    'status'  => 'string'
  ];

  public static $rules = [
    'sender'  => 'required|integer',
    'post_date'  => 'required|date',
    'return_date' => 'required|date',
    'customer_name' => 'required',
    'customer_phone' => 'required',
    'tracking_no' => 'required|unique:parcel_return_records'
  ];

  public function user() {
    return $this->belongsTo(\App\User::class, 'user_id');
  }

  public function sender() {
    return $this->belongsTo(\App\User::class, 'sender');
  }
}