<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model
{
  use SoftDeletes;

  public $table = 'orders';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'name',
    'address',
    'phone_no',
    'email',
    'order_date',
    'total_sales',
    'delivery_method',
    'is_shipped',
    'is_paid',
    'remarks',
    'extra_data',
    'order_label',
    'created_by',
    'updated_by',
    'postage_cost',
    'total_cost_price',
    'payment_date',
    'tracking_no',
    'shipping_date'
  ];

  protected $casts = [
    'id'  => 'integer',
    'name'  => 'string',
    'address'  => 'string',
    'phone_no' => 'string',
    'email' => 'string',
    'delivery_method' => 'string',
    'order_date'  => 'date|Y-m-d',
    'payment_date' => 'date|Y-m-d H:i:s',
    'shipping_date' => 'date|Y-m-d',
    'total_sales'  => 'float',
    'postage_cost' => 'float',
    'total_cost_price' => 'float',
    'is_shipped'  => 'boolean',
    'is_paid' => 'boolean',
    'remarks' => 'string',
    'extra_data' => 'string',
    'order_label' => 'string',
    'tracking_no' => 'string'
  ];

  public static $rules = [
    'name' =>  'required', 
    'phone_no' => 'required',
    'order_date'  => 'required|date_format:"Y-m-d"',
    'total_sales' => 'required|numeric',
    'delivery_method' => 'required',
    // 'is_shipped'  => 'required',
    // 'is_paid' => 'required'
  ];

  public function products() {
    return $this->belongsToMany(\App\Product::class, 'order_products', 'order_id', 'product_id')
            ->withPivot('id', 'qty', 'cost_price', 'total_cost_price', 'created_by', 'updated_by')
            ->withTimestamps();
  }

  public function order_items() {
    return $this->hasMany(\App\OrderItems::class);
  }

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updatedBy() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }

  public function order_groups() {
    return $this->belongsToMany(\App\OrderGroup::class, 'order_items', 'order_id', 'order_group_id')
            ->where('order_groups.status', 1)
            ->wherePivot('status', 1)
            ->withPivot('id', 'status', 'created_by', 'updated_by')
            ->withTimestamps();
  }

  public function shipments() {
    return $this->belongsToMany(\App\Shipment::class, 'order_shipments', 'order_id', 'shipment_id')
            ->where('shipments.status', 1)
            ->wherePivot('status', 1)
            ->withPivot('id', 'status', 'created_by', 'updated_by')
            ->withTimestamps();
  }
}