<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\WorkingDay;
use Carbon\Carbon;

class WorkingDayController extends Controller
{

  public function index(Request $request) {
    $data = WorkingDay::where('is_working', true);

    if ($request->query('month')) {
      $data = $data->where('date', 'like', $request->query('month').'%');
    }
    if(app('auth')->user()->hasRole('Admin')) {
      if ($request->query('user_id')) {
        $data = $data->where('user_id', $request->query('user_id'));
      }
    } 
    if(app('auth')->user()->hasRole('Sales Leader')) {
      $data = $data->where('user_id', app('auth')->user()->id);
    }
    if(app('auth')->user()->hasRole('Sales')) {
      $data = $data->where('user_id', app('auth')->user()->parent_id);
    }

    $data = $data->orderBy('date', 'asc')->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $rules = WorkingDay::$rules;
    $this->validate($request, $rules);

    $params = $request->all();

    if (is_array($params['date'])) {
      $pdate = $params['date'][0];
      $arrDate = $params['date'];
    } else {
      $pdate = $params['date'];
      $arrDate = [$params['date']];
    }

    list($year, $month, $day) = explode('-', $pdate);
    $date = $year.'-'.$month;

    $start = Carbon::parse($date)->startOfMonth();
    $end = Carbon::parse($date)->endOfMonth();

    while ($start->lte($end)) {
      info($start->format("Y-m-d"));
      $curr_date = $start->format("Y-m-d");
      $found = false;
      if(in_array($curr_date, $arrDate)){
        info('found: '.$curr_date);
        $found = true;
      }
      $data = WorkingDay::updateOrCreate(['user_id' => app('auth')->user()->id, 
      'date' => $curr_date], ['is_working' => $found]);
      $start->addDay();
    }

    return response()->json(['message' => 'Success'], 200);
  }
}