<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\StockBalance;
use Carbon\Carbon;

class StockBalanceController extends Controller
{

  public function index(Request $request) {
    $data = StockBalance::orderBy('report_date', 'desc');

    if($request->query('from_date') && $request->query('end_date')) {
      $data = $data->whereBetween('report_date', [$request->query('from_date'), $request->query('end_date')]);
    }
    // if($request->query('from_date_return') && $request->query('end_date_return')) {
    //   $data = $data->whereBetween('return_date', [$request->query('from_date_return'), $request->query('end_date_return')]);
    // }
    $data = $data->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $params = $request->all();
    $rules = StockBalance::$rules;

    $this->validate($request, $rules);
    // if (app('auth')->user()->hasRole('Marketing')) {
    //   $params['user_id'] = app('auth')->user()->id;
    // }

    $data = StockBalance::create($params);
    return response()->json($data, 201);
  }

  public function show($id) {
    return response()->json(StockBalance::findOrFail($id));
  }

  public function update($id, Request $request) {
    $data = StockBalance::findOrFail($id);
    $params = $request->all();

    $rules = StockBalance::$rules;

    $rules['report_date'] = [
      'required', 
      Rule::unique('stock_balance_records')->where(function ($query) use ($id, $params) {
        return $query->where('id', '<>', $id)
                    ->where('report_date', $params['report_date']);
      })
    ];
    
    $this->validate($request, $rules);
    $params = $request->all();
    $data->update($params);
    return response()->json($data, 200);
  }

  public function destroy($id) {
    $data = StockBalance::findOrFail($id);
    
    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }
}