<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\Order;
use Carbon\Carbon;

class ShipmentController extends Controller
{
  

  public function store(Request $request) {
    $params = $request->all();

    if(isset($params['tracking_no']) && is_array($params['tracking_no'])) {

      foreach($params['tracking_no'] as $key => $val) {
        $data = Order::findOrFail($val['id']);
        $data = $data->update([
          'tracking_no' => $val['tracking_no'], 
          'is_shipped' => true, 
          'shipping_date' => $params['shipping_date']
        ]);
      }
      return response()->json(['message' => 'Add tracking number successfully']);
    } 
  }

  
}