<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\Product;
use Carbon\Carbon;
use App\Tracking;
use App\Setting;
use App\Category;

class ProductController extends Controller
{

  public function index(Request $request) {

    
    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = Product::orderBy('name', 'asc'); 
      $data = $data->get();

    } else {
      $data = Product::where('status', true)->orderBy('name', 'asc'); 
      $data = $data->get();
      
      $setting = Setting::where('key', 'domain')->first();
      $domains = json_decode($setting->value);

      $categories = Category::where('created_by', app('auth')->user()->id)->get();

      foreach($data as $d) {
        $arr_link = [];
        foreach($domains as $domain) {
          $arr_link[] = $domain."/".app('auth')->user()->referal_code."/".$d->id;
        }

        $cat_link = [];
        foreach($categories as $cat) {
          $cat_cat_link = [];
          foreach($domains as $domain) {
            $cat_cat_link[] = $domain."/".app('auth')->user()->referal_code."/".$d->id."/".$cat->id;
          }
          $cc_link = [
            "id" => $cat->id,
            "category_name" => $cat->name,
            "link" => $cat_cat_link
          ];
          if (!app('auth')->user()->hasRole('Superadmin')) {
            $tracking = Tracking::where('product_id', $d->id)
              ->where('category_id', $cat->id)
              ->where('created_by', app('auth')->user()->id);

            if($request->query('from_date') && $request->query('end_date')) {
              $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
              $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
              $tracking = $tracking->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
            }
      
            $cc_link['tracking_count'] = $tracking->count();
          }
          $cat_link[] = $cc_link;
        }

        $d['main_link'] = $arr_link;
        $d['category_link'] = $cat_link;

      }
    }

    foreach($data as $row) {
      $tracking = Tracking::where('product_id', $row['id']);
      if (app('auth')->user()->hasRole('Superadmin')) {
        if($request->query('user_id')) {
          $tracking = $tracking->where('created_by', $request->query('user_id'));
        }
      } else {
        $tracking = $tracking->where('created_by', app('auth')->user()->id);
      }

      if($request->query('from_date') && $request->query('end_date')) {
        $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
        $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
        $tracking = $tracking->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
      }

      $tracking = $tracking->count();
      $row['tracking_count'] = $tracking;
    }
    
    return response()->json($data);
  }

  public function trackings(Request $request) {
    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = Product::orderBy('name', 'asc'); 
    } else {
      $data = Product::where('status', true)->orderBy('name', 'asc'); 
    }
    $data = $data->get();

    foreach ($data as $d) {
      if (app('auth')->user()->hasRole('Superadmin')) {
        $trackings = Tracking::selectRaw("city, state, country, count(*) as count")
        ->where('product_id', $d->id)->groupBy('city', 'state', 'country')
        ->orderBy('country','asc')
        ->orderBy('state','asc')
        ->orderBy('city','asc');
      } else {
        $trackings = Tracking::selectRaw("city, state, country, count(*) as count")
        ->where('created_by', app('auth')->user()->id)
        ->where('product_id', $d->id)->groupBy('city', 'state', 'country')
        ->orderBy('country','asc')
        ->orderBy('state','asc')
        ->orderBy('city','asc');
      }

      if($request->query('from_date') && $request->query('end_date')) {
        $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
        $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
        $trackings = $trackings->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
      }
      $d['trackings'] = $trackings->get();
    }

    return response()->json($data);
  }

  public function store(Request $request) {
    $this->validate($request, Product::$rules);

    $params = $request->all();

    if(isset($params['status'])) {
      $params['status'] = filter_var($params['status'], FILTER_VALIDATE_BOOLEAN);
    }

    $product = Product::create($params);
    
    $data = Product::findOrFail($product->id);
    return response()->json($data, 201);
  }

  public function show(Request $request, $id) {
    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = Product::findOrFail($id);
    } else {
      $data = Product::where('status', true)
      ->findOrFail($id);
    }
    $tracking = Tracking::where('product_id', $data->id);
    $trackings = Tracking::selectRaw('city, state, country, count(*) as count')
      ->where('product_id', $data->id)
      ->groupBy('city', 'state', 'country')
      ->orderBy('country','asc')
      ->orderBy('state','asc')
      ->orderBy('city','asc');

    if($request->query('from_date') && $request->query('end_date')) {
      $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
      $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
      $tracking = $tracking->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
      $trackings = $trackings->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
    }

    if (!app('auth')->user()->hasRole('Superadmin')) {
      $categories = Category::where('created_by', app('auth')->user()->id)->get();

      $arr_cat = [];
      foreach ($categories as $cat) {
        $track_cat = Tracking::where('product_id', $data->id)
          ->where('category_id', $cat->id);
        $track_cats = Tracking::selectRaw('city, state, country, count(*) as count')
          ->where('product_id', $data->id)
          ->where('category_id', $cat->id)
          ->groupBy('city', 'state', 'country')
          ->orderBy('country','asc')
          ->orderBy('state','asc')
          ->orderBy('city','asc');

        if($request->query('from_date') && $request->query('end_date')) {
          $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
          $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
          $track_cat = $track_cat->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
          $track_cats = $track_cats->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
        }
        $arr_cat[] = [
          "category_id" => $cat->id,
          "category_name" => $cat->name,
          "tracking_count" => $track_cat->count(),
          "trackings" => $track_cats->get()
        ];
      }
      $data['categories'] = $arr_cat;
    }

    $data['tracking_count'] = $tracking->count();
    $data['trackings'] = $trackings->get();
    return response()->json($data);
  }

  public function update(Request $request, $id) {
    $product = Product::findOrFail($id);
    $rules = Product::$rules;

    $rules['code'] = [
      'required', 
      Rule::unique('products')->where(function ($query) use ($id) {
        return $query->where('id', '<>', $id);
      })
    ];

    $this->validate($request, $rules);
    $params = $request->all();

    if(isset($params['status'])) {
      $params['status'] = filter_var($params['status'], FILTER_VALIDATE_BOOLEAN);
    }

    $product->update($params);

    $data = Product::findOrFail($product->id);
    return response()->json($data, 200);
  }

  public function destroy($id) {
    $data = Product::findOrFail($id);

    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }

}