<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\PaymentSeller;
use App\User;
use Carbon\Carbon;

class PaymentSellerController extends Controller
{

  public function index(Request $request) {
    $data = PaymentSeller::orderBy('report_date', 'desc');

    if($request->query('date')) {
      $data = $data->where('report_date', 'like', $request->query('date').'%');
    }
    // if($request->query('from_date_return') && $request->query('end_date_return')) {
    //   $data = $data->whereBetween('return_date', [$request->query('from_date_return'), $request->query('end_date_return')]);
    // }
    $data = $data->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $params = $request->all();
    $rules = PaymentSeller::$rules;

    $this->validate($request, $rules);
    // if (app('auth')->user()->hasRole('Marketing')) {
    //   $params['user_id'] = app('auth')->user()->id;
    // }

    $data = PaymentSeller::updateOrCreate([
      'report_date' => $params['report_date'],
      'user_id' => $params['user_id']
    ], [
      'payment' => $params['payment'],
      'deduction' => $params['deduction']
    ]);
    return response()->json($data, 200);
  }

  public function show($id) {
    return response()->json(PaymentSeller::findOrFail($id));
  }

  public function destroy($id) {
    $data = PaymentSeller::findOrFail($id);
    
    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }

  public function monthly(Request $request) {
    $users = User::role('Sales')->orderBy('name','asc')->get();
    $this_month = date('Y-m');
    $last_month = Carbon::now()->subMonth()->format('Y-m');
    $arr = [];

    foreach ($users as $user) {
      $sales = PaymentSeller::where('user_id', $user->id)
        ->where('report_date', 'like', $this_month.'%')
        ->sum('payment');
      
      $sales_prev = PaymentSeller::where('user_id', $user->id)
        ->where('report_date', 'like', $last_month.'%')
        ->sum('payment');

      $arr[] = [
        'user'  => $user->name,
        'sales' => (float) $sales,
        'sales_prev' => (float) $sales_prev
      ];
    }
    return response()->json($arr);
  }
}