<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\Courier;

class CourierController extends Controller
{

  public function index(Request $request) {

    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = Courier::with(['creator']); 

    } else {
      $data = Courier::where('status', true); 
      
    }

    $data = $data->get();
    foreach($data as $d) {
      $d->matchers = json_decode($d->matchers);
    }
    return response()->json($data);
  }

  public function store(Request $request) {
    $this->validate($request, Courier::$rules);

    $params = $request->all();
    $params['created_by'] = app('auth')->user()->id;
    $params['updated_by'] = app('auth')->user()->id;

    $courier = Courier::create($params);

    return response()->json($courier, 201);
  }

  public function show($id) {
    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = Courier::findOrFail($id);
    } else {
      $data = Courier::where('status', true)
      ->findOrFail($id);
    }
    $data->matchers = json_decode($data->matchers);
    return response()->json($data);
  }

  public function update(Request $request, $id) {
    if (app('auth')->user()->hasRole('Superadmin')) {
      $courier = Courier::findOrFail($id);
    } else {
      $courier = Courier::where('status', true)
        ->findOrFail($id);
    }
    
    $rules = Courier::$rules;

    $this->validate($request, $rules);
    $params = $request->all();

    $courier->update($params);

    return response()->json($courier, 200);
  }

  public function destroy($id) {
    $data = Courier::findOrFail($id);

    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }
}