<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\Attendance;
use App\User;
use Carbon\Carbon;
use App\Setting;

class AttendanceController extends Controller
{

  public function index(Request $request) {
    $data = Attendance::with(['user'])->orderBy('date', 'desc');

    if($request->query('from_date') && $request->query('end_date')) {
      $data = $data->whereBetween('date', [$request->query('from_date'), $request->query('end_date')]);
    }

    if ($request->query('date')) {
      $data = $data->where('date', 'like', $request->query('date').'%');
    }
    if(app('auth')->user()->hasRole('Admin')) {
      if ($request->query('user_id')) {
        $data = $data->where('user_id', $request->query('user_id'));
      }
      if ($request->query('assigned_by')) {
        $data = $data->where('assigned_by', $request->query('assigned_by'));
      }
    } 
    if(app('auth')->user()->hasRole('Sales Leader')) {
      $data = $data->where('assigned_by', app('auth')->user()->id);
    }

    $data = $data->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $rules = Attendance::$rules;
    $this->validate($request, $rules);

    $params = $request->all();

    // $users = User::where('parent_id', app('auth')->user()->id)->get();

    // if (is_array($params['user_id'])) {
    //   $user_ids = $params['user_id'];
    // } else {
    //   $user_ids = [ $params['user_id'] ];
    // }

    // foreach($users as $user) {
    //   $is_absent = true;
    //   if (in_array($user->id, $user_ids)){
    //     $is_absent = false;
    //   }
    //   $data = Attendance::updateOrCreate(['user_id' => $user->id, 'date' => $params['date']],
    //   ['is_absent' => $is_absent, 'assigned_by' => app('auth')->user()->id]);
    // }
    $setting = Setting::where('key', 'sales_lead_daily')->first();
    info($setting);
    $params['is_absent'] = filter_var($params['is_absent'], FILTER_VALIDATE_BOOLEAN);
    $data = Attendance::updateOrCreate(['user_id' => $params['user_id'], 'date' => $params['date']],
    ['is_absent' => $params['is_absent'], 'assigned_by' => app('auth')->user()->id, 'default_leads_limit' => (int) $setting->value]);

    return response()->json(['message' => 'Success'], 200);
  }

  public function update($id, Request $request) {

    if(app('auth')->user()->hasRole('Admin')) {
      $data = Attendance::findOrFail($id);
    }

    if(app('auth')->user()->hasRole('Sales Leader')) {
      $data = Attendance::where('assigned_by', app('auth')->user()->id)
      ->where('id', $id)->firstOrFail();
    }

    $rules = [
      'is_absent' => 'required'
    ];

    $this->validate($request, $rules);
    $params = $request->all();

    $params['is_absent'] = filter_var($params['is_absent'], FILTER_VALIDATE_BOOLEAN);
    $data->update($params);
    return response()->json($data, 200);
  }
}