<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\AdType;

class AdTypeController extends Controller
{

  public function index() {
    $data = AdType::all();
    return response()->json($data);
  }

  public function store(Request $request) {
    $this->validate($request, AdType::$rules);

    $data = AdType::create($request->all());
    return response()->json($data, 201);
  }

  public function show($id) {
    return response()->json(AdType::findOrFail($id));
  }

  public function update($id, Request $request) {
    $data = AdType::findOrFail($id);
    $rules = AdType::$rules;
    $this->validate($request, $rules);
    $data->update($request->all());

    return response()->json($data, 200);
  }

  public function destroy($id) {
    $ad_type = AdType::with(['campaigns'])->findOrFail($id);
    if (count($ad_type->campaigns) > 0) {
      return response()->json(['message' => 'Unable to delete - There is other data depends on this ad type.'], 403);
    }
    $ad_type->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }
}