<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DeliveryOrder extends Model
{
  use SoftDeletes;

  public $table = 'delivery_orders';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'delivery_order_no',
    'delivery_order_date',
    'courier_id',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'delivery_order_date'  => 'date:Y-m-d H:i:s',
    'delivery_order_no' => 'string',
    'courier_id' => 'integer'
  ];

  public static $rules = [
    // 'delivery_order_date'  => 'required|date_format:"Y-m-d H:i:s"',
    'courier_id' => 'required'
  ];

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updatedBy() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }

  public function trackings() {
    return $this->hasMany(\App\Tracking::class);
  }

  public function courier() {
    return $this->belongsTo(\App\Courier::class);
  }
}