<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DailyStockOut extends Model
{
  //use SoftDeletes;

  public $table = 'daily_sales_stock_out';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'report_date',
    'records'
  ];

  protected $casts = [
    'id'  => 'integer',
    'report_date'  => 'date|Y-m-d',
    'records'  => 'array'
  ];

  public static $rules = [
    'report_date'  => 'required|date|unique:daily_sales_stock_out',
    'records' => 'required'
  ];

}