<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DailyReportSales extends Model
{
  //use SoftDeletes;

  public $table = 'daily_report_sales';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'product_id',
    'user_id',
    'report_date',
    'lead_bizapp_total',
    'lead_bizapp_close',
    'lead_bizapp_close_qty',
    'lead_bizapp_close_amount',
    'lead_bizapp_paid',
    'lead_bizapp_paid_qty',
    'lead_bizapp_paid_amount',
    'lead_rebut_total',
    'lead_rebut_close',
    'lead_rebut_close_qty',
    'lead_rebut_close_amount',
    'lead_rebut_paid',
    'lead_rebut_paid_qty',
    'lead_rebut_paid_amount',
    'lead_direct_total',
    'lead_direct_close',
    'lead_direct_close_qty',
    'lead_direct_close_amount',
    'lead_direct_paid',
    'lead_direct_paid_qty',
    'lead_direct_paid_amount'
  ];

  protected $casts = [
    'id'  => 'integer',
    'product_id'  => 'integer',
    'user_id' => 'integer',
    'report_date'  => 'date|Y-m-d',
    'lead_bizapp_total' => 'integer',
    'lead_bizapp_close' => 'integer',
    'lead_bizapp_close_qty' => 'integer',
    'lead_bizapp_close_amount' => 'float',
    'lead_bizapp_paid' => 'integer',
    'lead_bizapp_paid_qty' => 'integer',
    'lead_bizapp_paid_amount' => 'float',
    'lead_rebut_total' => 'integer',
    'lead_rebut_close' => 'integer',
    'lead_rebut_close_qty' => 'integer',
    'lead_rebut_close_amount' => 'float',
    'lead_rebut_paid' => 'integer',
    'lead_rebut_paid_qty' => 'integer',
    'lead_rebut_paid_amount' => 'float',
    'lead_direct_total' => 'integer',
    'lead_direct_close' => 'integer',
    'lead_direct_close_qty' => 'integer',
    'lead_direct_close_amount' => 'float',
    'lead_direct_paid' => 'integer',
    'lead_direct_paid_qty' => 'integer',
    'lead_direct_paid_amount' => 'float'
  ];

  public static $rules = [
    'product_id'  => 'required|integer',
    'report_date'  => 'required|date'
  ];

  public function product() {
    return $this->belongsTo(\App\Product::class);
  }

  public function user() {
    return $this->belongsTo(\App\User::class, 'user_id');
  }
}