<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DailyReportParcel extends Model
{
  //use SoftDeletes;

  public $table = 'daily_report_parcel';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'report_date',
    'qty'
  ];

  protected $casts = [
    'id'  => 'integer',
    'report_date'  => 'date|Y-m-d',
    'qty'  => 'integer'
  ];

  public static $rules = [
    'report_date'  => 'required|date|unique:daily_report_parcel',
    'qty' => 'required|integer'
  ];

}