<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DailyReportMarketing extends Model
{
  //use SoftDeletes;

  public $table = 'daily_report_marketing';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'product_id',
    'user_id',
    'report_date',
    'daily_ads_spending',
    'total_daily_leads'
  ];

  protected $casts = [
    'id'  => 'integer',
    'product_id'  => 'integer',
    'user_id' => 'integer',
    'report_date'  => 'date|Y-m-d',
    'daily_ads_spending' => 'float',
    'total_daily_leads' => 'integer'
  ];

  public static $rules = [
    'product_id'  => 'required|integer',
    'report_date'  => 'required|date',
    'daily_ads_spending' => 'required|numeric',
    'total_daily_leads' => 'required|integer'
  ];

  public function product() {
    return $this->belongsTo(\App\Product::class);
  }

  public function user() {
    return $this->belongsTo(\App\User::class, 'user_id');
  }
}