<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Courier extends Model
{
  use SoftDeletes;

  public $table = 'couriers';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'name',
    'description',
    'status',
    'matchers',
    'code',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'name'  => 'string',
    'description' => 'string',
    'code'  => 'string',
    'status'  => 'boolean',
    'matchers' => 'array'
  ];

  public static $rules = [
    'name'  => 'required',
    'matchers'  => 'required',
    'code' => 'required'
  ];

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updatedBy() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }
  
}