<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AdType extends Model
{
  //use SoftDeletes;

  public $table = 'ad_types';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'name',
    'description',
    'status'
  ];

  protected $casts = [
    'id'  => 'integer',
    'name'  => 'string',
    'description' => 'string',
    'status'  => 'boolean'
  ];

  public static $rules = [
    'name'  => 'required'
  ];

  public function campaigns() {
    return $this->hasMany(\App\Campaign::class);
  }
}