<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->post('auth/login', 'AuthController@login');
$router->get('auth/logout', 'AuthController@logout');
$router->get('auth/me', 'AuthController@me');
$router->post('auth/change-password', 'AuthController@change_password');
$router->post('auth/forgot-password', 'AuthController@forgot_password');
$router->post('auth/reset-password', 'AuthController@reset_password');
$router->post('auth/register', 'AuthController@register');
$router->get('auth/test-email', 'AuthController@test_email');
$router->get('auth/email-confirm', 'AuthController@confirm_email');
$router->post('payment/callback', 'PaymentController@callback');
$router->post('dummy', function () use ($router) {
  return response()->json([
    'test' => 'OK'
  ]);
});

$router->get('do/{id}', 'DeliveryOrderController@download');

// $router->post('rotate', 'SellerRotatorController@rotate');

$router->group(['prefix' => 'api/v1', 'middleware' => ['auth']], function() use ($router) {
    
    // SETTINGS
    $router->get('settings', ['uses' => 'SettingController@index', 'middleware' => ['role:Superadmin']]);
    $router->post('settings', ['uses' => 'SettingController@store', 'middleware' => ['role:Superadmin']]);
    
    // USER
    $router->get('users', ['uses' => 'UserController@index']);
    $router->get('users/{id}', ['uses' => 'UserController@show']);
    $router->post('users', ['uses' => 'UserController@store', 'middleware' => ['role:Superadmin']]);
    $router->put('users/{id}', ['uses' => 'UserController@update', 'middleware' => ['role:Superadmin']]);
    $router->delete('users/{id}', ['uses' => 'UserController@destroy', 'middleware' => ['role:Superadmin']]);
    $router->post('users/{id}/products', ['uses' => 'UserController@add_products', 'middleware' => ['role:Superadmin']]);

    // USER GROUP
    // $router->get('usergroups', ['uses' => 'UserGroupController@index']);
    // $router->get('usergroups/{id}', ['uses' => 'UserGroupController@show']);
    // $router->post('usergroups', ['uses' => 'UserGroupController@store', 'middleware' => ['role:Superadmin']]);
    // $router->put('usergroups/{id}', ['uses' => 'UserGroupController@update', 'middleware' => ['role:Superadmin']]);
    // $router->delete('usergroups/{id}', ['uses' => 'UserGroupController@destroy', 'middleware' => ['role:Superadmin']]);
    // $router->post('usergroups/{id}/products', ['uses' => 'UserGroupController@add_products', 'middleware' => ['role:Superadmin']]);

    // FIGHTERS
    // $router->get('fighters', ['uses' => 'UserController@fighters']);

    // ROLE
    $router->get('roles', ['uses' => 'RoleController@index', 'middleware' => ['role:Superadmin']]);
    $router->get('roles/{id}', ['uses' => 'RoleController@show', 'middleware' => ['role:Superadmin']]);

    // TRACKING
    $router->get('trackings', ['uses' => 'TrackingController@index']);
    $router->get('trackings/dashboard', ['uses' => 'TrackingController@dashboard']);
    $router->get('trackings/location', ['uses' => 'TrackingController@location']);
    $router->get('trackings/weekly', ['uses' => 'TrackingController@weekly']);
    $router->get('trackings/monthly', ['uses' => 'TrackingController@monthly']);
    $router->get('trackings/yearly', ['uses' => 'TrackingController@yearly']);
    $router->get('trackings/unknown', ['uses' => 'TrackingController@unknown_courier']);
    $router->get('trackings/{id}', ['uses' => 'TrackingController@show']);
    // $router->post('trackings', ['uses' => 'TrackingController@store']);
    // $router->put('trackings/{id}', ['uses' => 'TrackingController@update', 'middleware' => ['role:Superadmin|Admin']]);
    // $router->delete('trackings/{id}', ['uses' => 'TrackingController@destroy', 'middleware' => ['role:Superadmin|Admin']]);

    // REFERAL
    $router->get('referal', ['uses' => 'ReferalController@index']);
    $router->get('referal/{id}', ['uses' => 'ReferalController@show']);
    $router->post('referal', ['uses' => 'ReferalController@store']);
    $router->put('referal/{id}', ['uses' => 'ReferalController@update']);
    $router->delete('referal/{id}', ['uses' => 'ReferalController@destroy']);
    
    // COURIER
    $router->get('couriers', ['uses' => 'CourierController@index']);
    $router->get('couriers/{id}', ['uses' => 'CourierController@show']);
    $router->post('couriers', ['uses' => 'CourierController@store', 'middleware' => ['role:Superadmin']]);
    $router->put('couriers/{id}', ['uses' => 'CourierController@update', 'middleware' => ['role:Superadmin']]);
    $router->delete('couriers/{id}', ['uses' => 'CourierController@destroy', 'middleware' => ['role:Superadmin']]);

    // DELIVERY ORDER
    $router->get('delivery-orders', ['uses' => 'DeliveryOrderController@index', 'middleware' => ['role:Superadmin|Admin']]);
    $router->get('delivery-orders/{id}', ['uses' => 'DeliveryOrderController@show', 'middleware' => ['role:Superadmin|Admin']]);
    $router->post('delivery-orders', ['uses' => 'DeliveryOrderController@store', 'middleware' => ['role:Superadmin|Admin']]);
    $router->post('delivery-orders/daily', ['uses' => 'DeliveryOrderController@daily', 'middleware' => ['role:Superadmin|Admin']]);
    $router->get('delivery-orders/download/{id}', ['uses' => 'DeliveryOrderController@download', 'middleware' => ['role:Superadmin|Admin']]);
    $router->put('delivery-orders/{id}', ['uses' => 'DeliveryOrderController@update', 'middleware' => ['role:Superadmin|Admin']]);
    $router->delete('delivery-orders/{id}', ['uses' => 'DeliveryOrderController@destroy', 'middleware' => ['role:Superadmin|Admin']]);

    // ORDER
    // $router->get('orders', ['uses' => 'OrderController@index', 'middleware' => ['role:Superadmin|User']]);
    // $router->post('orders', ['uses' => 'OrderController@store', 'middleware' => ['role:Superadmin|User']]);
    // $router->post('orders/upload', ['uses' => 'OrderController@upload', 'middleware' => ['role:Superadmin|User']]);
    // $router->get('orders/{id}', ['uses' => 'OrderController@show', 'middleware' => ['role:Superadmin|User']]);
    // $router->put('orders/{id}', ['uses' => 'OrderController@update', 'middleware' => ['role:Superadmin|User']]);
    // $router->delete('orders/destroy', ['uses' => 'OrderController@bulkDestroy', 'middleware' => ['role:Superadmin|User']]);
    // $router->delete('orders/{id}', ['uses' => 'OrderController@destroy', 'middleware' => ['role:Superadmin|User']]);

    // ORDER GROUP
    // $router->get('order-groups', ['uses' => 'OrderGroupController@index', 'middleware' => ['role:Superadmin|User']]);
    // $router->post('order-groups', ['uses' => 'OrderGroupController@store', 'middleware' => ['role:Superadmin|User']]);
    // $router->get('order-groups/{id}', ['uses' => 'OrderGroupController@show', 'middleware' => ['role:Superadmin|User']]);
    // $router->put('order-groups/{id}', ['uses' => 'OrderGroupController@update', 'middleware' => ['role:Superadmin|User']]);
    // $router->delete('order-groups/{id}', ['uses' => 'OrderGroupController@destroy', 'middleware' => ['role:Superadmin|User']]);

    // CATEGORY
    $router->get('categories', ['uses' => 'CategoryController@index']);
    $router->get('categories/trackings', ['uses' => 'CategoryController@trackings']);
    $router->get('categories/{id}', ['uses' => 'CategoryController@show']);
    $router->post('categories', ['uses' => 'CategoryController@store']);
    $router->put('categories/{id}', ['uses' => 'CategoryController@update']);
    $router->delete('categories/{id}', ['uses' => 'CategoryController@destroy']);
    
    // PRODUCT
    $router->get('products', ['uses' => 'ProductController@index']);
    $router->get('products/trackings', ['uses' => 'ProductController@trackings']);
    $router->get('products/{id}', ['uses' => 'ProductController@show']);
    $router->post('products', ['uses' => 'ProductController@store', 'middleware' => ['role:Superadmin']]);
    $router->put('products/{id}', ['uses' => 'ProductController@update', 'middleware' => ['role:Superadmin']]);
    $router->delete('products/{id}', ['uses' => 'ProductController@destroy', 'middleware' => ['role:Superadmin']]);
    // $router->post('products/{id}/supergroups', ['uses' => 'ProductController@add_supergroups', 'middleware' => ['role:Superadmin']]);

    // PAYMENT
    // $router->post('payments', ['uses' => 'PaymentController@store', 'middleware' => ['role:User']]);

    // SHIPMENT
    // $router->post('shipments', ['uses' => 'ShipmentController@store', 'middleware' => ['role:Superadmin']]);

    // // DAILY REPORT MARKETING
    // $router->get('daily-report-marketing', ['uses' => 'DailyReportMarketingController@index', 'middleware' => ['role:Superadmin|Marketing']]);
    // $router->get('daily-report-marketing/summary', ['uses' => 'DailyReportMarketingController@summary', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-report-marketing/monthly', ['uses' => 'DailyReportMarketingController@monthly', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-report-marketing/weekly', ['uses' => 'DailyReportMarketingController@weekly', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-report-marketing/yearly', ['uses' => 'DailyReportMarketingController@yearly', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-report-marketing/dashboard', ['uses' => 'DailyReportMarketingController@dashboard', 'middleware' => ['role:Superadmin|Marketing']]);
    // $router->get('daily-report-marketing/{id}', ['uses' => 'DailyReportMarketingController@show', 'middleware' => ['role:Superadmin|Marketing']]);
    // $router->post('daily-report-marketing', ['uses' => 'DailyReportMarketingController@store', 'middleware' => ['role:Superadmin|Marketing']]);
    // $router->put('daily-report-marketing/{id}', ['uses' => 'DailyReportMarketingController@update', 'middleware' => ['role:Superadmin|Marketing']]);
    // $router->delete('daily-report-marketing/{id}', ['uses' => 'DailyReportMarketingController@destroy', 'middleware' => ['role:Superadmin|Marketing']]);

    // // DAILY REPORT SALES
    // $router->get('daily-report-sales', ['uses' => 'DailyReportSalesController@index', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->get('daily-report-sales/summary', ['uses' => 'DailyReportSalesController@summary', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-report-sales/dashboard', ['uses' => 'DailyReportSalesController@dashboard', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->get('daily-report-sales/weekly', ['uses' => 'DailyReportSalesController@weekly', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->get('daily-report-sales/{id}', ['uses' => 'DailyReportSalesController@show', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->post('daily-report-sales', ['uses' => 'DailyReportSalesController@store', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->put('daily-report-sales/{id}', ['uses' => 'DailyReportSalesController@update', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->delete('daily-report-sales/{id}', ['uses' => 'DailyReportSalesController@destroy', 'middleware' => ['role:Superadmin|Sales']]);

    // // DAILY SUMMARY SALES
    // $router->get('daily-summary-sales', ['uses' => 'DailySummarySalesController@index', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->get('daily-summary-sales/dashboard', ['uses' => 'DailySummarySalesController@dashboard', 'middleware' => ['role:Superadmin|Sales']]);
    // // $router->get('daily-summary-sales/weekly', ['uses' => 'DailySummarySalesController@weekly', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->get('daily-summary-sales/{id}', ['uses' => 'DailySummarySalesController@show', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->post('daily-summary-sales', ['uses' => 'DailySummarySalesController@store', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->put('daily-summary-sales/{id}', ['uses' => 'DailySummarySalesController@update', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->delete('daily-summary-sales/{id}', ['uses' => 'DailySummarySalesController@destroy', 'middleware' => ['role:Superadmin|Sales']]);

    // // PARCEL RETURN RECORDS
    // $router->get('parcel-return', ['uses' => 'ParcelReturnController@index', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->get('parcel-return/dashboard', ['uses' => 'ParcelReturnController@dashboard', 'middleware' => ['role:Superadmin|Logistic']]);
    // // $router->get('daily-summary-sales/weekly', ['uses' => 'DailySummarySalesController@weekly', 'middleware' => ['role:Superadmin|Sales']]);
    // $router->get('parcel-return/{id}', ['uses' => 'ParcelReturnController@show', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->post('parcel-return', ['uses' => 'ParcelReturnController@store', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->put('parcel-return/{id}', ['uses' => 'ParcelReturnController@update', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->delete('parcel-return/{id}', ['uses' => 'ParcelReturnController@destroy', 'middleware' => ['role:Superadmin|Logistic']]);

    // // STOCK BALANCE RECORDS
    // $router->get('stock-balance', ['uses' => 'StockBalanceController@index', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->get('stock-balance/{id}', ['uses' => 'StockBalanceController@show', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->post('stock-balance', ['uses' => 'StockBalanceController@store', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->put('stock-balance/{id}', ['uses' => 'StockBalanceController@update', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->delete('stock-balance/{id}', ['uses' => 'StockBalanceController@destroy', 'middleware' => ['role:Superadmin|Logistic']]);

    // // DAILY REPORT PARCEL
    // $router->get('daily-report-parcel', ['uses' => 'DailyReportParcelController@index', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->get('daily-report-parcel/summary', ['uses' => 'DailyReportParcelController@summary', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-report-parcel/dashboard', ['uses' => 'DailyReportParcelController@dashboard', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->get('daily-report-parcel/yearly', ['uses' => 'DailyReportParcelController@yearly', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->get('daily-report-parcel/monthly', ['uses' => 'DailyReportParcelController@monthly', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->get('daily-report-parcel/weekly', ['uses' => 'DailyReportParcelController@weekly', 'middleware' => ['role:Superadmin|Logistic']]);    
    // $router->get('daily-report-parcel/{id}', ['uses' => 'DailyReportParcelController@show', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->post('daily-report-parcel', ['uses' => 'DailyReportParcelController@store', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->put('daily-report-parcel/{id}', ['uses' => 'DailyReportParcelController@update', 'middleware' => ['role:Superadmin|Logistic']]);
    // $router->delete('daily-report-parcel/{id}', ['uses' => 'DailyReportParcelController@destroy', 'middleware' => ['role:Superadmin|Logistic']]);

    // // DAILY SALES STOCK OUT
    // $router->get('daily-stock-out', ['uses' => 'DailyStockOutController@index', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->get('daily-stock-out/weekly', ['uses' => 'DailyStockOutController@weekly', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->get('daily-stock-out/{id}', ['uses' => 'DailyStockOutController@show', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->post('daily-stock-out', ['uses' => 'DailyStockOutController@store', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->put('daily-stock-out/{id}', ['uses' => 'DailyStockOutController@update', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->delete('daily-stock-out/{id}', ['uses' => 'DailyStockOutController@destroy', 'middleware' => ['role:Superadmin|Administration']]);

    // // DAILY SALES
    // $router->get('daily-sales', ['uses' => 'DailySalesController@index', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->get('daily-sales/top-seller', ['uses' => 'DailySalesController@top_seller', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-sales/top-fighters', ['uses' => 'DailySalesController@top_fighters', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-sales/analysis', ['uses' => 'DailySalesController@analysis', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-sales/dashboard', ['uses' => 'DailySalesController@dashboard', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-sales/summary', ['uses' => 'DailySalesController@summary', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-sales/weekly', ['uses' => 'DailySalesController@weekly', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-sales/monthly', ['uses' => 'DailySalesController@monthly', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-sales/yearly', ['uses' => 'DailySalesController@yearly', 'middleware' => ['role:Superadmin']]);
    // $router->get('daily-sales/{id}', ['uses' => 'DailySalesController@show', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->post('daily-sales', ['uses' => 'DailySalesController@store', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->put('daily-sales/{id}', ['uses' => 'DailySalesController@update', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->delete('daily-sales/{id}', ['uses' => 'DailySalesController@destroy', 'middleware' => ['role:Superadmin|Administration']]);

    // // DAILY PAYMENT SELLER
    // $router->get('payment-seller', ['uses' => 'PaymentSellerController@index', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->get('payment-seller/monthly', ['uses' => 'PaymentSellerController@monthly', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->get('payment-seller/{id}', ['uses' => 'PaymentSellerController@show', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->post('payment-seller', ['uses' => 'PaymentSellerController@store', 'middleware' => ['role:Superadmin|Administration']]);
    // // $router->put('daily-payment-seller/{id}', ['uses' => 'DailySalesController@update', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->delete('payment-seller/{id}', ['uses' => 'PaymentSellerController@destroy', 'middleware' => ['role:Superadmin|Administration']]);

    // // DAILY SALES FIGHTER
    // $router->get('sales-fighter', ['uses' => 'SalesFighterController@index', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->get('sales-fighter/dashboard', ['uses' => 'SalesFighterController@dashboard', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->get('sales-fighter/{id}', ['uses' => 'SalesFighterController@show', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->post('sales-fighter', ['uses' => 'SalesFighterController@store', 'middleware' => ['role:Superadmin|Administration']]);
    // // $router->put('daily-payment-seller/{id}', ['uses' => 'DailySalesController@update', 'middleware' => ['role:Superadmin|Administration']]);
    // $router->delete('sales-fighter/{id}', ['uses' => 'SalesFighterController@destroy', 'middleware' => ['role:Superadmin|Administration']]);

    // // SELLER ROTATOR
    // $router->get('seller-rotator', ['uses' => 'SellerRotatorController@index', 'middleware' => ['role:Superadmin']]);
    // $router->get('seller-rotator/{id}', ['uses' => 'SellerRotatorController@show', 'middleware' => ['role:Superadmin']]);
    // $router->post('seller-rotator', ['uses' => 'SellerRotatorController@store', 'middleware' => ['role:Superadmin']]);
});

// $router->get('{referal_code}/{product_id}/{category_id}', 'TrackingController@store');
// $router->get('{referal_code}/{product_id}', 'TrackingController@store');
$router->get('{referal_code}', 'TrackingController@store');