<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkingDay extends Model
{
  //use SoftDeletes;

  public $table = 'working_days';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'user_id',
    'date',
    'is_working'
  ];

  protected $casts = [
    'id'  => 'integer',
    'user_id'  => 'integer',
    'date'  => 'date|Y-m-d',
    'is_working'  => 'boolean'
  ];

  public static $rules = [
    'date'  => 'required'
  ];

  public function user() {
    return $this->belongsTo(\App\User::class);
  }
}