<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserGroupProduct extends Model
{
  use SoftDeletes;

  public $table = 'product_usergroups';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'product_id',
    'usergroup_id',
    'price',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'product_id' => 'integer',
    'usergroup_id' => 'integer',
    'price'  => 'float'
  ];

  public static $rules = [
    'sku' =>  'required', 
    'order_id' => 'required',
    'price' => 'required|numeric'
  ];

  public function product() {
    return $this->belongsTo(\App\Product::class);
  }

  public function usergroup() {
    return $this->belongsTo(\App\UserGroup::class);
  }

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updated_by() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }
}