<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserGroup extends Model
{
  //use SoftDeletes;

  public $table = 'usergroups';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'name',
    'description',
    'status',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'name'  => 'string',
    'description'  => 'string',
    'status' => 'boolean'
  ];

  public static $rules = [
    'name' =>  'required'
  ];

  public function users() {
    return $this->hasMany(\App\User::class);
  }

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updated_by() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }

  public function products() {
    return $this->belongsToMany(\App\Product::class, 'product_usergroups', 'usergroup_id', 'product_id')
            ->withPivot('id', 'price', 'created_by', 'updated_by')
            ->withTimestamps();
  }
}