<?php

namespace App;

use Illuminate\Auth\Authenticatable;
use Laravel\Lumen\Auth\Authorizable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Tymon\JWTAuth\Contracts\JWTSubject as AuthenticatableUserContract;

use Spatie\Permission\Traits\HasRoles;

class User extends Model implements AuthenticatableContract, AuthorizableContract, AuthenticatableUserContract
{
    use Authenticatable, Authorizable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
      'name', 'username', 'email', 'password', 'phone_no', 'status', 'token', 'verified', 'forgot_password_token', 'referal_code'
  ];

  /**
   * The attributes excluded from the model's JSON form.
   *
   * @var array
   */
  protected $hidden = [
      'password', 'token', 'forgot_password_token'
  ];

  protected $casts = [
      'id'  => 'integer',
      'name'  => 'string',
      'username'  => 'string',
      'password' => 'string',
      'email' => 'string',
      'phone_no' => 'string',
      'status' => 'boolean',
      'token' => 'string',
      'verified' => 'boolean',
      'forgot_password_token' => 'string',
      'referal_code' => 'string'
    ];

  public static $rules = [
    'name' => 'bail|required|min:2',
    'username' => 'required|min:3|unique:users',
    'email' => 'required|email|unique:users',
    'password' => 'required|min:5',
    'roles' => 'required|min:1',
    // 'referal_code' => 'required|unique:users'
    // 'usergroup_id' => 'required'
  ];

  // protected static function boot() {
  //   parent::boot();

  //   static::creating(function ($model) {
  //       // $user->referal_code = uniqid();
  //       $model->_generateReferalCode();
  //   });
  // }

  private function _generateReferalCode () {

    // make sure our value is unique by checking it doesn't exist already
    while(empty($this->referal_code) || self::findByReferalCode($this->referal_code, ['id'])) {
      $this->referal_code = $this->random_strings(10);
    }
  }

  public static function findByReferalCode ($code, $columns = []) {

    if(count($columns) < 1) $columns = null;

    // get our candidate by access code
    $code = self::where('referal_code', '=', $code)->first($columns);

    // return our candidate
    return $code;
  }

  private function random_strings($length_of_string) 
  { 
      $str_result = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz'; 
      return substr(str_shuffle($str_result), 0, $length_of_string); 
  } 


    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    // public function usergroup() {
    //   return $this->belongsTo(\App\UserGroup::class);
    // }
}
