<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tracking extends Model
{
  use SoftDeletes;

  public $table = 'trackings';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'user_id',
    'product_id',
    'category_id',
    'referal_id',
    'url',
    'commission',
    'ip',
    'city',
    'state',
    'country',
    'referer',
    'user_agent',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'ip'  => 'string',
    'url' => 'string',
    'commission' => 'float',
    'city' => 'string',
    'state' => 'string',
    'country' => 'string',
    'referer' => 'string',
    'user_agent' => 'string'
  ];

  public static $rules = [
    'ip'  => 'required'
  ];
  
  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updatedBy() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }

  public function product() {
    return $this->belongsTo(\App\Product::class);
  }

  public function category() {
    return $this->belongsTo(\App\Category::class);
  }

  public function referal() {
    return $this->belongsTo(\App\Referal::class);
  }
}