<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockBalance extends Model
{
  //use SoftDeletes;

  public $table = 'stock_balance_records';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'report_date',
    'records'
  ];

  protected $casts = [
    'id'  => 'integer',
    'report_date'  => 'date|Y-m-d',
    'records'  => 'array'
  ];

  public static $rules = [
    'report_date'  => 'required|date|unique:stock_balance_records',
    'records' => 'required'
  ];

}