<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shipment extends Model
{
  //use SoftDeletes;

  public $table = 'shipments';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'shipment_date',
    'shipment_no',
    'status',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'shipment_date'  => 'date|Y-m-d H:i:s',
    'shipment_no' => 'string'
    // 'status' => 'integer'
  ];

  public static $rules = [
    'shipment_date'  => 'required|date_format:"Y-m-d H:i:s"'
  ];

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updatedBy() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }

  public function orders() {
    return $this->belongsToMany(\App\Order::class, 'order_shipments', 'shipment_id', 'order_id')
            ->withPivot('id', 'status', 'created_by', 'updated_by')
            ->withTimestamps();
  }
}