<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalesTarget extends Model
{
  //use SoftDeletes;

  public $table = 'sales_targets';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'user_id',
    'date',
    'daily_target',
    'monthly_target',
    'daily_target_ind',
    'monthly_target_ind'
  ];

  protected $casts = [
    'id'  => 'integer',
    'user_id'  => 'integer',
    'date'  => 'date|Y-m',
    'daily_target'  => 'float',
    'monthly_target' => 'float',
    'daily_target_ind'  => 'float',
    'monthly_target_ind' => 'float'
  ];

  public static $rules = [
    'date'  => 'required|date_format:"Y-m"',
    'daily_target' => 'required|numeric',
    'monthly_target' => 'required|numeric',
    'daily_target_ind' => 'required|numeric',
    'monthly_target_ind' => 'required|numeric'
  ];

  public function user() {
    return $this->belongsTo(\App\User::class);
  }
}