<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalesFighter extends Model
{
  //use SoftDeletes;

  public $table = 'daily_sales_fighter';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'report_date',
    'user_id',
    'sales'
  ];

  protected $casts = [
    'id'  => 'integer',
    'user_id' => 'integer',
    'report_date'  => 'date|Y-m-d',
    'sales'  => 'float'
  ];

  public static $rules = [
    'report_date'  => 'required|date',
    'user_id' => 'required|integer',
    'sales'  => 'required|numeric'
  ];

  public function user() {
    return $this->belongsTo(\App\User::class, 'user_id');
  }
}