<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sale extends Model
{
  //use SoftDeletes;

  public $table = 'sales';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'campaign_id',
    'product_id',
    'lead_id',
    'assigned_to',
    'sales_date',
    'price',
    'qty',
    'total_sales',
    'commission_sales',
    'commission_marketing',
    'call_status',
    'is_shipped',
    'is_paid',
    'remarks',
    'name',
    'address',
    'city',
    'state',
    'postcode',
    'tracking_no',
    'shipping_date',
    'shipping_remarks',
    'image',
    'request_shipping'
  ];

  protected $casts = [
    'id'  => 'integer',
    'campaign_id'  => 'integer',
    'product_id'  => 'integer',
    'lead_id' => 'integer',
    'assigned_to' => 'integer',
    'sales_date'  => 'date|Y-m-d',
    'price'  => 'float',
    'qty' => 'integer',
    'total_sales' => 'float',
    'commission_sales'  => 'float',
    'commission_marketing'  => 'float',
    'call_status' => 'string',
    'is_shipped'  => 'boolean',
    'is_paid' => 'boolean',
    'remarks' => 'string',
    'name'  => 'string',
    'address' => 'string',
    'city'  => 'string',
    'state' => 'string',
    'postcode'  => 'string',
    'tracking_no' => 'string',
    'shipping_date' => 'datetime|Y-m-d H:i:s',
    'shipping_remarks'  => 'string',
    'image' => 'string',
    'request_shipping'  => 'boolean'
  ];

  public static $rules = [
    'lead_id' =>  'required', 
    'sales_date'  => 'required|date_format:"Y-m-d"',
    //'price' => 'required|numeric',
    'qty' => 'required|numeric',
    'total_sales' => 'required|numeric',
    'call_status' => 'required',
    'is_shipped'  => 'required',
    'is_paid' => 'required'
  ];

  public function campaign() {
    return $this->belongsTo(\App\Campaign::class);
  }
  public function product() {
    return $this->belongsTo(\App\Product::class);
  }
  public function lead() {
    return $this->belongsTo(\App\CampaignLead::class, 'lead_id');
  }
  public function assignee() {
    return $this->belongsTo(\App\User::class, 'assigned_to');
  }
}