<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Referal extends Model
{
  use SoftDeletes;

  public $table = 'referal';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'product_id',
    'category_id',
    'code',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'code'  => 'string',
  ];

  public static $rules = [
    'product_id'  => 'required'
  ];

  protected static function boot() {
    parent::boot();

    static::creating(function ($model) {
        // $user->referal_code = uniqid();
        $model->_generateReferalCode();
    });
  }

  private function _generateReferalCode () {

    // make sure our value is unique by checking it doesn't exist already
    while(empty($this->code) || self::findByReferalCode($this->code, ['id'])) {
      $this->code = $this->random_strings(7);
    }
  }

  public static function findByReferalCode ($code, $columns = []) {

    if(count($columns) < 1) $columns = null;

    // get our candidate by access code
    $code = self::where('code', '=', $code)->first($columns);

    // return our candidate
    return $code;
  }

  private function random_strings($length_of_string) 
  { 
      $str_result = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz'; 
      return substr(str_shuffle($str_result), 0, $length_of_string); 
  } 
  
  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updatedBy() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }

  public function product() {
    return $this->belongsTo(\App\Product::class);
  }

  public function category() {
    return $this->belongsTo(\App\Category::class);
  }

}