<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
  use SoftDeletes;

  public $table = 'products';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'name',
    'code',
    'description',
    'url',
    'status',
    'image',
    'commission_type',
    'commission'
  ];

  protected $casts = [
    'id'  => 'integer',
    'name'  => 'string',
    'code'  => 'string',
    'description' => 'string',
    'url' => 'string',
    'status'  => 'boolean',
    'image' => 'string',
    'commission_type' => 'string',
    'commission' => 'float'
  ];

  public static $rules = [
    'name'  => 'required',
    'code'  => 'required|unique:products,code,NULL,id,deleted_at,NULL',
    'url' => 'required'
  ];

  public function trackings() {
    return $this->hasMany(\App\Tracking::class);
  }
  
}