<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentSeller extends Model
{
  //use SoftDeletes;

  public $table = 'daily_payment_seller';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'report_date',
    'user_id',
    'payment',
    'deduction'
  ];

  protected $casts = [
    'id'  => 'integer',
    'user_id' => 'integer',
    'report_date'  => 'date|Y-m-d',
    'payment'  => 'float',
    'deduction'  => 'float'
  ];

  public static $rules = [
    'report_date'  => 'required|date',
    'user_id' => 'required|integer',
    'payment' => 'required|numeric',
    'deduction' => 'required|numeric'
  ];

  public function user() {
    return $this->belongsTo(\App\User::class, 'user_id');
  }
}