<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderProduct extends Model
{
  //use SoftDeletes;

  public $table = 'order_products';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'order_id',
    'sku',
    'qty',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'order_id' => 'integer',
    'sku'  => 'string',
    'qty'  => 'integer'
  ];

  public static $rules = [
    'sku' =>  'required', 
    'order_id' => 'required',
    'qty' => 'required|numeric'
  ];

  public function order() {
    return $this->belongsTo(\App\Order::class);
  }

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updated_by() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }
}