<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderItem extends Model
{
  //use SoftDeletes;

  public $table = 'order_items';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'order_group_id',
    'order_id',
    'status',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'order_group_id'  => 'integer',
    'order_id'  => 'integer',
    // 'status' => 'integer'
  ];

  public static $rules = [
    'order_group_id' =>  'required', 
    'order_id' => 'required'
  ];

  public function order_group() {
    return $this->belongsTo(\App\OrderGroup::class);
  }

  public function order() {
    return $this->belongsTo(\App\Order::class);
  }

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updated_by() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }
}