<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderGroup extends Model
{
  //use SoftDeletes;

  public $table = 'order_groups';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'payment_date',
    'order_no',
    'payment_provider',
    'bill_no',
    'status',
    'state',
    'payment_request',
    'payment_response',
    'payment_callback',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'payment_date'  => 'date|Y-m-d H:i:s',
    'order_no' => 'string',
    'payment_provider' => 'string',
    'bill_no' => 'string',
    'state' => 'string',
    'payment_request' => 'string',
    'payment_response' => 'string',
    'payment_callback' => 'string'
    // 'status' => 'integer'
  ];

  public static $rules = [
    'payment_date'  => 'required|date_format:"Y-m-d H:i:s"'
  ];

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function updatedBy() {
    return $this->belongsTo(\App\User::class, 'updated_by');
  }

  public function orders() {
    return $this->belongsToMany(\App\Order::class, 'order_items', 'order_group_id', 'order_id')
            ->withPivot('id', 'status', 'created_by', 'updated_by')
            ->withTimestamps();
  }
}