<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\UserGroup;
use App\Product;

class UserGroupController extends Controller
{

  public function index() {

    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = UserGroup::with(['products']); 

    } else {
      $data = UserGroup::where('id', app('auth')->user()->usergroup_id)
        ->where('status', true); 
      
    }
    $data = $data->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    // $this->validate($request, Order::$rules);

    $params = $request->all();
    $params['created_by'] = app('auth')->user()->id;
    $params['updated_by'] = app('auth')->user()->id;

    if(isset($params['status']) && $params['status']) {
      $params['status'] = filter_var($params['status'], FILTER_VALIDATE_BOOLEAN);
    }

    $usergroup = UserGroup::create($params);

    if (isset($params['products']) && is_array($params['products'])) {
      
      foreach($params['products'] as $product) {
        $usergroup->products()->syncWithoutDetaching(array(
          $product['id'] => array(
            "price" => $product['price'],
            "created_by" => $params['created_by'],
            "updated_by" => $params['updated_by']
          )
        )
      );
      }
    }
    
    $data = UserGroup::with(['products'])->findOrFail($usergroup->id);
    return response()->json($data, 201);
  }

  public function show($id) {
    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = UserGroup::with(['products'])
      ->findOrFail($id);
    } else {
      $data = UserGroup::where('status', true)
      ->findOrFail($id);
    }
    return response()->json($data);
  }

  public function update(Request $request, $id) {
    $usergroup = UserGroup::findOrFail($id);
    $rules = UserGroup::$rules;

    $this->validate($request, $rules);
    $params = $request->all();

    if(isset($params['status'])) {
      $params['status'] = filter_var($params['status'], FILTER_VALIDATE_BOOLEAN);
    }

    $usergroup->update($params);

    if (isset($params['products']) && is_array($params['products'])) {
      
      foreach($params['products'] as $product) {
        $usergroup->products()->syncWithoutDetaching(array(
          $product['id'] => array(
            "price" => $product['price'],
            "created_by" => $usergroup->created_by ? $usergroup->created_by : app('auth')->user()->id,
            "updated_by" => app('auth')->user()->id
          )
        )
      );
      }
    }
    $data = UserGroup::with(['products'])->findOrFail($usergroup->id);
    return response()->json($data, 200);
  }

  public function destroy($id) {
    $data = UserGroup::with(['products'])
      ->findOrFail($id);

    $data->products()->detach();
    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }

  public function add_products(Request $request, $id) {
    $data = UserGroup::with(['products'])
      ->findOrFail($id);

    $params = $request->all();
    if(is_array($params['products'])) {
      foreach ($params['products'] as $product) {
        $data->products()->syncWithoutDetaching(array(
          $product['id'] => array(
            "price" => $product['price'],
            "created_by" => app('auth')->user()->id,
            "updated_by" => app('auth')->user()->id
          )
        ));
      }
    }
    

    return response()->json(['message' => 'Add product to usergroup successfully'], 200);
  }
}