<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\User;
use App\Role;
use App\SellerRotator;
use App\Tracking;
use Carbon\Carbon;

class UserController extends Controller
{

  public function index(Request $request) {
    if(app('auth')->user()->hasRole('Superadmin')) {
      $data = User::with(['roles']);
      if($request->query('role')) {
        $data = $data->role($request->query('role'));
        // $datas = [];
        // foreach($data as $d) {
        //   if ($d->hasRole($request->query('role'))){
        //     $datas[] = $d;
        //   }
        // };
        // $data = $datas;
      }
    }
    if(app('auth')->user()->hasRole('Admin')) {
      $data = User::role('User');
    }

    $data = $data->orderBy('name', 'asc')->get();

    if (app('auth')->user()->hasRole('Superadmin')) {
      foreach($data as $row) {
        $tracking = Tracking::where('created_by', $row->id);
  
        if($request->query('from_date') && $request->query('end_date')) {
          $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
          $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
          $tracking = $tracking->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
        }
  
        $tracking = $tracking->get();

        $commissions = 0;
        foreach($tracking as $t) {
          $commissions += $t->commission;
        }
        $row['tracking_count'] = count($tracking);
        $row['commission'] = number_format($commissions,2);
      }
    }
  
    return response()->json($data);
  }

  public function fighters(Request $request) {
    // if(app('auth')->user()->hasRole('Administration')) {
      $data = User::role('Fighter');
    // }

    
    $data = $data->orderBy('name', 'asc')->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $rules = User::$rules;
    $this->validate($request, $rules);

    $params = $request->all();
    $params['password'] = password_hash($params['password'], PASSWORD_DEFAULT);

    $role = Role::where('id', $params['roles'])->first();

    if (!$role) {
      return response()->json(['error' => 'Invalid role.'], 403);
    }

    $data = User::create($params);
    $data->assignRole($role->name);

    return response()->json($data, 201);
  }

  public function show($id) {
    if(app('auth')->user()->hasRole('Superadmin')) {
      $data = User::with(['roles'])->findOrFail($id);
    }

    return response()->json($data);
  }

  public function update(Request $request, $id) {
    $data = User::findOrFail($id);
    $rules = User::$rules;

    $rules['email'] = 'sometimes|required|email|unique:users,email,'.$id;
    $rules['username'] = 'sometimes|required|min:3|unique:users,username,'.$id;
    //$rules['password'] = 'sometimes|required|min:6';
    $rules['roles'] = 'sometimes|required|min:1';
    unset($rules['password']);

    $this->validate($request, $rules);
    $params = $request->all();

    if (isset($params['password']) && $params['password'] != '') {
      $params['password'] = password_hash($params['password'], PASSWORD_DEFAULT);
    } else {
      unset($params['password']);
    }

    $data->update($params);

    if (isset($params['roles'])) {
      $role = Role::where('id', $params['roles'])->first();

      if (!$role) {
        return response()->json(['error' => 'Invalid role.'], 403);
      }
      $data->syncRoles([$role->name]);
      
    }
    

    return response()->json($data, 200);
  }

  public function destroy($id) {
    $data = User::findOrFail($id);

    $data->delete();

    return response()->json(['message' => 'Delete Successfully'], 200);
  }

  public function add_products(Request $request, $id) {
    $data = User::findOrFail($id);
    $params = $request->all();
    if(is_array($params['product_id'])) {
      $product_ids = $params['product_id'];
    } else {
      $product_ids = [ $params['product_id']];
    }
    $data->products()->syncWithoutDetaching($product_ids);

    return response()->json(['message' => 'Add product to users successfully'], 200);
  }
}