<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\Setting;

class SettingController extends Controller
{

  public function index() {
    $settings = Setting::orderBy('keygroup', 'asc')->get();
    $data = [];
    foreach($settings as $setting) {
      switch($setting->type) {
        case 'integer': $data[$setting->key] = (int) $setting->value; break;
        case 'string': $data[$setting->key] = (string) $setting->value; break;
        case 'boolean': $data[$setting->key] = (boolean) $setting->value; break;
        case 'json': $data[$setting->key] = json_decode($setting->value); break;
      }
    }
    return response()->json($data);
  }

  public function store(Request $request) {
    $params = $request->all();

    foreach($params['fields'] as $key => $val){
      //info($key.' = '.$val);
      $setting = Setting::where('key', $key)->first();
      $setting->update(['value' => $val]);
    }
    return response()->json(['message' => 'Success'], 200);
  }
}