<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\SellerRotator;
use App\User;
use App\Product;
use Carbon\Carbon;

class SellerRotatorController extends Controller
{

  public function index(Request $request) {
    $data = SellerRotator::with(['user', 'user.products'])->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $params = $request->all();
    $rules = SellerRotator::$rules;

    // $this->validate($request, $rules);
    // if (app('auth')->user()->hasRole('Marketing')) {
    //   $params['user_id'] = app('auth')->user()->id;
    // }

    $data = SellerRotator::updateOrCreate([
      'user_id' => $params['user_id']
    ], [
      'weight' => $params['weight'],
      'status' => $params['status']
    ]);
    return response()->json($data, 200);
  }

  public function show($id) {
    return response()->json(SellerRotator::findOrFail($id));
  }

  public function rotate(Request $request) {
    $data = SellerRotator::where('status', true)->with(['user'])->get();

    $users = [];
    if ($request->query('code')) {
      $product = Product::where('code', $request->query('code'))->first();
      if ($product) {
        $users = User::whereHas('products', function($q) use($product) {
          $q->where('product_id', $product->id);
        })->pluck('id')->toArray();

      }
    }

    if (count($data) > 0 && (array_search(true, array_column($data->toArray(), 'current')) > -1)) {
      $found = null;
      foreach ($data as $k => $d) {
        if ($d->current) {
          if ($d->weight_current < $d->weight) {

            if (count($users) > 0) {
              $j = $k;

              while($j <= count($data)) {
                if (in_array($data[$j]->user_id, $users)) {
                  $found = $data[$j];
                  break;
                } 
                if ($j == count($data)) {
                  $j = 0;
                } else {
                  $j++;
                }
              }
            } else {
              $found = $d;
            }
          } else {
            if (count($users) > 0) {
              if (isset($data[$k+1])) {
                $j = $k+1;
              } else {
                $j = 0;
              }

              while($j <= count($data)) {
                if (in_array($data[$j]->user_id, $users)) {
                  $found = $data[$j];
                  break;
                } 
                if ($j == count($data)) {
                  $j = 0;
                } else {
                  $j++;
                }
              }
            } else {
              if (isset($data[$k+1])) {
                $found = $data[$k+1];
              } else {
                $found = $data[0];
              }
            }
          }
          break;
        }
      }
      
      $found->update([
        'weight_current' => $found->weight_current + 1,
        'current' => true,
        'counter' => $found->counter + 1
      ]);
      $update = SellerRotator::where('id', '<>', $found->id)
        ->update([
          'current' => false,
          'weight_current' => 0
        ]);
      $data = $found;
    } else {
      $data = SellerRotator::where('status', true)->with(['user'])->orderBy('id', 'asc')->first();

      if ($data) {
        $arr = $data->update([
          'current' => true,
          'counter' => $data->current + 1,
          'weight_current' => 1
        ]);
      }
    }

    return $data->user->phone_no;
  }
}