<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\SalesTarget;
use Carbon\Carbon;

class SalesTargetController extends Controller
{

  public function index(Request $request) {
    $data = SalesTarget::with(['user'])->orderBy('date', 'desc');

    if ($request->query('month')) {
      $data = $data->where('date', 'like', $request->query('month').'%');
    }
    if(app('auth')->user()->hasRole('Admin')) {
      if ($request->query('user_id')) {
        $data = $data->where('user_id', $request->query('user_id'));
      }
    } 
    if(app('auth')->user()->hasRole('Sales Leader')) {
      $data = $data->where('user_id', app('auth')->user()->id);
    }
    if(app('auth')->user()->hasRole('Sales')) {
      $data = $data->where('user_id', app('auth')->user()->parent_id);
    }

    $data = $data->orderBy('date', 'asc')->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $rules = SalesTarget::$rules;
    $this->validate($request, $rules);

    $params = $request->all();

    $data = SalesTarget::updateOrCreate([
      'user_id' => app('auth')->user()->id, 
      'date' => $params['date']
    ],
      [
        'daily_target' => $params['daily_target'], 
        'monthly_target' => $params['monthly_target'],
        'daily_target_ind' => $params['daily_target_ind'], 
        'monthly_target_ind' => $params['monthly_target_ind']
      ]);

    return response()->json(['message' => 'Success'], 200);
  }

  public function update($id, Request $request) {

    if(app('auth')->user()->hasRole('Admin')) {
      $data = SalesTarget::findOrFail($id);
    }

    if(app('auth')->user()->hasRole('Sales Leader')) {
      $data = SalesTarget::where('user_id', app('auth')->user()->id)
      ->where('id', $id)->firstOrFail();
    }

    $rules = SalesTarget::$rules;

    $this->validate($request, $rules);
    $params = $request->all();

    $data->update($params);
    return response()->json($data, 200);
  }
}