<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\SalesFighter;
use Carbon\Carbon;

class SalesFighterController extends Controller
{

  public function index(Request $request) {
    $data = SalesFighter::orderBy('report_date', 'desc');

    if($request->query('date')) {
      $data = $data->where('report_date', 'like', $request->query('date'));
    }
    // if($request->query('from_date_return') && $request->query('end_date_return')) {
    //   $data = $data->whereBetween('return_date', [$request->query('from_date_return'), $request->query('end_date_return')]);
    // }
    $data = $data->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $params = $request->all();
    $rules = SalesFighter::$rules;

    $this->validate($request, $rules);
    // if (app('auth')->user()->hasRole('Marketing')) {
    //   $params['user_id'] = app('auth')->user()->id;
    // }

    $data = SalesFighter::updateOrCreate([
      'report_date' => $params['report_date'],
      'user_id' => $params['user_id']
    ], [
      'sales' => $params['sales']
    ]);
    return response()->json($data, 200);
  }

  public function show($id) {
    return response()->json(SalesFighter::findOrFail($id));
  }

  public function destroy($id) {
    $data = SalesFighter::findOrFail($id);
    
    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }

  public function dashboard(Request $request) {
    $this_month = date('Y-m');
    $last_month = Carbon::now()->subMonth()->format('Y-m');

    $data = SalesFighter::where('report_date', 'like', $this_month.'%')
      ->sum('sales');
    $data_prev = SalesFighter::where('report_date', 'like', $last_month.'%')
    ->sum('sales');

    return response()->json(['sales' => (float) $data, 'sales_prev' => (float) $data_prev]);
  }
}