<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use App\Setting;
use App\OrderGroup;
use App\Order;
use Billplz\Client;

class PaymentController extends Controller
{
  public function store(Request $request) {
    $params = $request->all();
    $settings = Setting::where('keygroup', 'billplz')->get();

    $billplz_api_secret = '';
    $billplz_collection_id = '';
    $billplz_sandbox = false;

    foreach($settings as $setting) {
      if ($setting->key == 'billplz_api_secret') {
        $billplz_api_secret = $setting->value;
      }
      if ($setting->key == 'billplz_collection_id') {
        $billplz_collection_id = $setting->value;
      }
      if ($setting->key == 'billplz_sandbox') {
        $billplz_sandbox = $setting->value == 1 ? true : false;
      }
    }

    $params['payment_date'] = date("Y-m-d H:i:s");
    $params['created_by'] = app('auth')->user()->id;
    $params['updated_by'] = app('auth')->user()->id;
    $params['payment_provider'] = 'billplz';

    $order_group = OrderGroup::create($params);
    $order_no = Carbon::today()->format('Ymd').str_pad($order_group->id, 6, "0", STR_PAD_LEFT);
    $order_group->update([
      "order_no" => $order_no
    ]);

    $total = 0;
    if (isset($params['orders']) && is_array($params['orders'])) {
      $orders = Order::whereIn('id', $params['orders'])
        ->where('is_paid', false)->with(['products'])->get();

      foreach($orders as $order) {
        $total += $order->total_cost_price;
        $order_group->orders()->syncWithoutDetaching(array(
          $order->id => array(
            "status" => false,
            "created_by" => $params['created_by'],
            "updated_by" => $params['updated_by']
          )
        )
      );
      }
    }

    $billplz = Client::make($billplz_api_secret);
    if ($billplz_sandbox) {
      $billplz->useSandbox();
    }

    $bill = $billplz->bill();

    // echo 'billplz_api_secret: '.$billplz_api_secret;
    // echo 'billplz_collection_id: '.$billplz_collection_id;

    $res = $bill->create(
      $billplz_collection_id,
      app('auth')->user()->email,
      null,
      app('auth')->user()->name,
      \Duit\MYR::given($total * 100),
      'http://example.com/webhook/',
      'Order No. '.$order_no,
      ['redirect_url' => 'http://localhost:9528/#/orders/'], // optional.
  )->toArray();
  $order_group->update([
    "bill_no" => $res['id'],
    "state" => $res['state'],
    "payment_response" => json_encode($res)
  ]);
  return response()->json($res);
  // var_dump($response->toArray());
  }

  public function callback(Request $request) {
    $params = $request->all();

    if (isset($params['id'])) {
      $order_group = OrderGroup::where('bill_no', $params['id'])->with(['orders'])->first();
      $order_group->update([
        "state" => $params['state'],
        "status" => (bool) $params['paid'] ? 1 : 0,
        "payment_callback" => json_encode($params)
      ]);

      foreach ($order_group->orders()->get() as $order) {

        if ((bool) $params['paid']) {
          $order->update([
            "is_paid" => true,
            "payment_date" => Carbon::now()
          ]);
        }
        $order_group->orders()->updateExistingPivot($order->id, [
          'status'  => (bool) $params['paid'] ? 1 : 0
        ]);
      } 
      
    }

    return response()->json();
    
  }
}