<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\ParcelReturn;
use Carbon\Carbon;

class ParcelReturnController extends Controller
{

  public function index(Request $request) {
    $data = ParcelReturn::with(['user', 'sender']);

    if($request->query('from_date') && $request->query('end_date')) {
      $data = $data->whereBetween('created_at', [$request->query('from_date'), $request->query('end_date')]);
    }
    // if($request->query('from_date_return') && $request->query('end_date_return')) {
    //   $data = $data->whereBetween('return_date', [$request->query('from_date_return'), $request->query('end_date_return')]);
    // }
    $data = $data->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $params = $request->all();
    $rules = ParcelReturn::$rules;

    $params['user_id'] = app('auth')->user()->id;

    $this->validate($request, $rules);
    // if (app('auth')->user()->hasRole('Marketing')) {
    //   $params['user_id'] = app('auth')->user()->id;
    // }

    $data = ParcelReturn::create($params);
    return response()->json($data, 201);
  }

  public function show($id) {
    return response()->json(ParcelReturn::with(['sender', 'user'])->findOrFail($id));
  }

  public function update($id, Request $request) {
    $data = ParcelReturn::findOrFail($id);
    $params = $request->all();

    $rules = ParcelReturn::$rules;

    $rules['tracking_no'] = [
      'required', 
      Rule::unique('parcel_return_records')->where(function ($query) use ($id, $data, $params) {
        return $query->where('id', '<>', $id)
                    ->where('tracking_no', $params['tracking_no']);
      })
    ];
    
    $this->validate($request, $rules);
    $params = $request->all();
    $data->update($params);
    return response()->json($data, 200);
  }

  public function destroy($id) {
    $data = ParcelReturn::with(['sender', 'user'])->findOrFail($id);
    
    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }

  // public function dashboard(Request $request) {
  //   $end = Carbon::now()->endOfMonth();
  //   $start = Carbon::now()->startOfMonth();
  //   $end_prev = Carbon::now()->subMonth()->endOfMonth();
  //   $start_prev = Carbon::now()->subMonth()->startOfMonth();

  //   $arr = $this->get_dashboard_data($start, $end);
  //   $arr_prev = $this->get_dashboard_data($start_prev, $end_prev);

  //   $data_arr = [];
  //   foreach($arr['leads'] as $k => $v) {
  //     $start = Carbon::now()->startOfMonth();
  //     $end = Carbon::now();
  //     $day_arr = [
  //       'product' => $k
  //     ];

  //     while($start->lte($end)) {
  //       $day = $start->format('Y-m-d');
  //       if (array_key_exists($day, $v)) {
  //         $day_arr[$day] = $v[$day];
  //       } else {
  //         $day_arr[$day] = 0;
  //       }
  //       $start->addDay();
  //     }
  //     $data_arr[] = $day_arr;
  //   }
  //   return response()->json([
  //     'avg_kpk' => $arr['avg_kpk'],
  //     'avg_kpk_prev' => $arr_prev['avg_kpk'],
  //     'total_ads_spending'  => $arr['total_ads_spending'],
  //     'total_ads_spending_prev'  => $arr_prev['total_ads_spending'],
  //     'total_leads' => $arr['total_leads'],
  //     'total_leads_prev' => $arr_prev['total_leads'],
  //     'commission' => $arr['commission'],
  //     'commission_prev' => $arr_prev['commission'],
  //     'leads' => $data_arr
  //   ]);
  // }

  // private function get_dashboard_data($start, $end) {
  //   //$end = Carbon::now()->endOfMonth();
  //   //$start = Carbon::now()->startOfMonth();
  //   $arr = [];
  //   $total_leads = 0;
  //   $total_ads_spending = 0;
  //   $commission = 0;
  //   $avg_kpk = 0;
  //   $total_day = 0;

  //   while($start->lte($end)) {
  //     // info($last_week->format('D'));
  //     $sum_avg = 0;
  //     $day = $start->format('Y-m-d');

  //     $costs = DailyReportMarketing::where('report_date', $day)->with(['product']);

  //     if(app('auth')->user()->hasRole('Marketing')) {
  //       $costs = $costs->where('user_id', app('auth')->user()->id);
  //     }

  //     $costs = $costs->get();

  //     if (count($costs) > 0) {
  //       foreach($costs as $cost) {
  //         $avg = $cost->daily_ads_spending / $cost->total_daily_leads;
  //         $total_ads_spending += $cost->daily_ads_spending;
  //         $total_leads += $cost->total_daily_leads;
  //         $sum_avg += $avg;

  //         if (array_key_exists($cost->product->name, $arr)) {
  //           $arr[$cost->product->name][$day] = $cost->total_daily_leads;
  //         } else {
  //           $arr[$cost->product->name] = [
  //             $day => $cost->total_daily_leads
  //           ];
  //         }
  //       }
  
  //       $avg_kpk += $sum_avg;
  //       $total_day++;
  //     }
      
  //     $start->addDay();
  //   }

  //   return [
  //     'avg_kpk' => $total_day > 0 ? (float) $avg_kpk / $total_day : 0,
  //     'total_ads_spending'  => (float) $total_ads_spending,
  //     'total_leads' => $total_leads,
  //     'commission' => (float) $total_leads * 0.5,
  //     'leads' => $arr
  //   ];
  // }
}