<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Order;
use App\OrderGroup;

class OrderGroupController extends Controller
{

  public function index() {

    if(app('auth')->user()->hasRole('User')) {
      $data = OrderGroup::where('created_by', app('auth')->user()->id)
        ->with(['orders'])->get();
    } else {
      $data = OrderGroup::with(['orders'])->get();      
    }
    return response()->json($data);
  }

  public function store(Request $request) {
    // $this->validate($request, Order::$rules);

    $params = $request->all();
    $params['payment_date'] = date("Y-m-d H:i:s");
    $params['created_by'] = app('auth')->user()->id;
    $params['updated_by'] = app('auth')->user()->id;

    $order_group = OrderGroup::create($params);

    if (is_array($params['orders'])) {
      $orders = Order::whereIn('id', $params['orders'])
        ->where('is_paid', false)->get();

      foreach($orders as $order) {
        $order_group->orders()->syncWithoutDetaching(array(
          $order->id => array(
            "created_by" => $params['created_by'],
            "updated_by" => $params['updated_by']
          )
        )
      );
      }
    }
    
    $data = OrderGroup::with(['orders'])->findOrFail($order_group->id);
    return response()->json($data, 201);
  }

  public function show($id) {
    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = OrderGroup::with(['orders'])
      ->findOrFail($id);
    } else {
      $data = OrderGroup::where('created_by', app('auth')->user()->id)->with(['orders'])
      ->findOrFail($id);
    }
    return response()->json($data);
  }

  public function update(Request $request, $id) {
    $order = OrderGroup::findOrFail($id);
    $rules = OrderGroup::$rules;

    $this->validate($request, $rules);
    $params = $request->all();

    $order->update($params);
    return response()->json($order, 200);
  }

  public function destroy($id) {
    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = OrderGroup::with(['orders'])
      ->findOrFail($id);
    } else {
      $data = OrderGroup::where('created_by', app('auth')->user()->id)->with(['orders'])
      ->findOrFail($id);
    }

    $data->orders()->detach();
    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }
}