<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\DailyStockOut;
use App\Product;
use Carbon\Carbon;

class DailyStockOutController extends Controller
{

  public function index(Request $request) {
    $data = DailyStockOut::orderBy('report_date', 'desc');

    if($request->query('from_date') && $request->query('end_date')) {
      $data = $data->whereBetween('report_date', [$request->query('from_date'), $request->query('end_date')]);
    }
    // if($request->query('from_date_return') && $request->query('end_date_return')) {
    //   $data = $data->whereBetween('return_date', [$request->query('from_date_return'), $request->query('end_date_return')]);
    // }
    $data = $data->get();
    return response()->json($data);
  }

  public function store(Request $request) {
    $params = $request->all();
    $rules = DailyStockOut::$rules;

    $this->validate($request, $rules);
    // if (app('auth')->user()->hasRole('Marketing')) {
    //   $params['user_id'] = app('auth')->user()->id;
    // }

    $data = DailyStockOut::create($params);
    return response()->json($data, 201);
  }

  public function show($id) {
    return response()->json(DailyStockOut::findOrFail($id));
  }

  public function update($id, Request $request) {
    $data = DailyStockOut::findOrFail($id);
    $params = $request->all();

    $rules = DailyStockOut::$rules;

    $rules['report_date'] = [
      'required', 
      Rule::unique('daily_sales_stock_out')->where(function ($query) use ($id, $params) {
        return $query->where('id', '<>', $id)
                    ->where('report_date', $params['report_date']);
      })
    ];
    
    $this->validate($request, $rules);
    $params = $request->all();
    $data->update($params);
    return response()->json($data, 200);
  }

  public function destroy($id) {
    $data = DailyStockOut::findOrFail($id);
    
    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }

  public function weekly(Request $request) {
    $start = Carbon::now()->startOfWeek(Carbon::MONDAY);
    $end = Carbon::now()->endOfWeek(Carbon::SUNDAY);

    $arr = [];

    $products = Product::orderBy('name', 'asc')->get();

    while($start->lte($end)) {
      $day = $start->format('Y-m-d');

      $stock = DailyStockOut::where('report_date', $day)->first();

      if ($stock) {
        foreach ($products as $product) {
          if (($key = array_search($product->id, array_column($stock->records, 'product_id'))) !== false) {
            $arr[$day][$product->code] = $stock->records[$key]['qty'];
          } else {
            $arr[$day][$product->code] = 0;
          }

        }
      } else {
        foreach ($products as $product) {
          $arr[$day][$product->code] = 0;
        }
      }
      $start->addDay();
    }

    $new_arr = [];

    foreach($arr as $k => $v) {
      $a = ['report_date' => $k];
      $new_arr[] = array_merge($a, $v);
    }

    return response()->json($new_arr);
  }
}