<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\Category;
use App\Product;
use App\Tracking;
use App\Referal;
use Carbon\Carbon;

class CategoryController extends Controller
{

  public function index(Request $request) {

    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = Category::orderBy('name', 'asc'); 
      $data = $data->get();

    } else {
      $data = Category::where('created_by', app('auth')->user()->id)->orderBy('name', 'asc'); 
      $data = $data->get();
      
      $referal = Referal::select('product_id')->where('created_by', app('auth')->user()->id)
        ->groupBy('product_id')->pluck('product_id')->toArray();
      $products = Product::where('status', true)
        ->whereIn('id', $referal)->orderBy('name', 'asc')->get();
      

      foreach ($data as $row) {
        $track_count = Tracking::where('created_by', app('auth')->user()->id)
        ->where('category_id', $row->id);

        $arr_products = [];
        foreach ($products as $product) {
          $trackings = Tracking::where('product_id', $product->id)
            ->where('category_id', $row->id);

          if($request->query('from_date') && $request->query('end_date')) {
            $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
            $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
            $trackings = $trackings->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
            //$track_count = $track_count->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
          }

          $trackings = $trackings->get();
          $commission=0;
          foreach($trackings as $t) {
            $commission += $t->commission;
          }
          $arr_products[] = array(
            "id" => $product->id,
            "name" => $product->name,
            "code" => $product->code,
            "tracking_count" => count($trackings),
            "commission" => number_format($commission, 2)
          );
        }
        if($request->query('from_date') && $request->query('end_date')) {
          $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
          $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
          $track_count = $track_count->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
        }

        $track_count = $track_count->get();
        $comm = 0;
        foreach($track_count as $t) {
          $comm += $t->commission;
        }
        $row['products'] = $arr_products;
        $row['tracking_count'] = count($track_count);
        $row['commission'] = number_format($comm, 2);
      }
    }

    return response()->json($data);
  }

  public function trackings(Request $request) {
    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = Category::orderBy('name', 'asc'); 
    } else {
      $data = Category::where('created_by', app('auth')->user()->id)->orderBy('name', 'asc'); 
    }
    $data = $data->get();

    if (!app('auth')->user()->hasRole('Superadmin')) {
      foreach ($data as $d) {
        $trackings = Tracking::selectRaw("city, state, country, count(*) as count, sum(commission) as total_commission")
          ->where('created_by', app('auth')->user()->id)
          ->where('category_id', $d->id)->groupBy('city', 'state', 'country')
          ->orderBy('country','asc')
          ->orderBy('state','asc')
          ->orderBy('city','asc');

        if($request->query('from_date') && $request->query('end_date')) {
          $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
          $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
          $trackings = $trackings->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
        }
        $d['trackings'] = $trackings->get();
      }
    }

    return response()->json($data);
  }

  public function store(Request $request) {
    $this->validate($request, Category::$rules);

    $params = $request->all();
    $params['created_by'] = app('auth')->user()->id;
    $params['updated_by'] = app('auth')->user()->id;

    $category = Category::create($params);
    
    $data = Category::findOrFail($category->id);
    return response()->json($data, 201);
  }

  public function show(Request $request, $id) {
    if (app('auth')->user()->hasRole('Superadmin')) {
      $data = Category::findOrFail($id);
    } else {
      $data = Category::where('created_by', app('auth')->user()->id)
      ->findOrFail($id);

      // $data = $data->get();
      $referal = Referal::select('product_id')
        ->where('category_id', $id)
        ->where('created_by', app('auth')->user()->id)
        ->groupBy('product_id')->pluck('product_id')->toArray();

      $products = Product::where('status', true)
        ->whereIn('id', $referal)->orderBy('name', 'asc')->get();

      $arr_products = [];
      foreach ($products as $product) {
        $trackings = Tracking::where('product_id', $product->id)
          ->where('category_id', $data->id);

        if($request->query('from_date') && $request->query('end_date')) {
          $start = Carbon::createFromFormat('Y-m-d', $request->query('from_date'));
          $end = Carbon::createFromFormat('Y-m-d', $request->query('end_date'));
          $trackings = $trackings->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
          //$track_count = $track_count->whereBetween('created_at', [$start->startOfDay()->format('Y-m-d H:i:s'), $end->endOfDay()->format('Y-m-d H:i:s')]);
        }

        $trackings = $trackings->get();
        $commission=0;
        foreach($trackings as $t) {
          $commission += $t->commission;
        }
        $arr_products[] = array(
          "id" => $product->id,
          "name" => $product->name,
          "code" => $product->code,
          "tracking_count" => count($trackings),
          "commission" => number_format($commission, 2)
        );
      }
      $data['products'] = $arr_products;
    }
    return response()->json($data);
  }

  public function update(Request $request, $id) {
    $category = Category::findOrFail($id);
    $rules = Category::$rules;

    $this->validate($request, $rules);
    $params = $request->all();

    $category->update($params);

    $data = Category::findOrFail($category->id);
    return response()->json($data, 200);
  }

  public function destroy($id) {
    $data = Category::with(['trackings'])->findOrFail($id);

    if (count($data->trackings) > 0) {
      return response()->json(['message' => 'Unable to delete - There is other data depends on this category.'], 403);
    }

    $data->delete();
    return response()->json(['message' => 'Delete Successfully'], 200);
  }

}