<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DailySummarySales extends Model
{
  //use SoftDeletes;

  public $table = 'daily_summary_sales';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'user_id',
    'report_date',
    'sales_repeat_order',
    'sales_unpaid',
    'total_payment_collected',
    'total_follow_up'
  ];

  protected $casts = [
    'id'  => 'integer',
    'user_id' => 'integer',
    'report_date'  => 'date|Y-m-d',
    'sales_repeat_order' => 'float',
    'sales_unpaid'  => 'float',
    'total_payment_collected' => 'float',
    'total_follow_up' => 'integer'
  ];

  public static $rules = [
    'report_date'  => 'required|date'
  ];

  public function user() {
    return $this->belongsTo(\App\User::class, 'user_id');
  }
}