<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DailySales extends Model
{
  //use SoftDeletes;

  public $table = 'daily_sales_record';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'report_date',
    'sales_bizapp',
    'sales_in_house',
    'sales_part_time',
    'sales_dropship',
    'sales_fighter',
    'gross_profit'
  ];

  protected $casts = [
    'id'  => 'integer',
    'report_date'  => 'date|Y-m-d',
    'sales_bizapp'  => 'float',
    'sales_in_house'  => 'float',
    'sales_part_time' => 'float',
    'sales_dropship'  => 'float',
    'sales_fighter' => 'float',
    'gross_profit'  => 'float'
  ];

  public static $rules = [
    'report_date'  => 'required|date|unique:daily_sales_record',
    'sales_bizapp' => 'required|numeric',
    'sales_in_house'  => 'required|numeric',
    'sales_part_time' => 'required|numeric',
    'sales_fighter' => 'required|numeric',
    'sales_dropship'  => 'required|numeric',
    'gross_profit'  => 'required|numeric'
  ];

}